/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xaddrmap.h 
 *       Adressmap for E2929A, public part (for CAPI compile)
 *       This file is included in Firmware, Core and CAPI !!!
 * -----------------------------------------------------------------*/

#ifndef XADDRMAP_H_INCLUDED
#define XADDRMAP_H_INCLUDED

#ifndef BEST_FIRMWARE 
#ifndef CORE_FIRMWARE

/* BestXDirectReg() functions need bx_int32 as
   type for address parameter. 
*/
#ifndef LINUX
typedef bx_int32 UDWORDADDR,ULONGADDR,UWORDADDR,ULONG;
#else
typedef bx_int32 UDWORDADDR,ULONGADDR,UWORDADDR;
#endif
                          
#endif
#endif

/*****************************************************************************
 * Mephisto
 *****************************************************************************/

#define BX_MEPHISTO_OFFSET            0x00400000

/* xmephist.h contains the auto-generated adresses for Mephisto */
#include "xmephist.h"


/*****************************************************************************
 * Display (4 characters)
 *****************************************************************************/

#define BX_DISPLAY_OFFSET                        (0x00510000)

/* The following four addressses are used to write a character to 
   each Digit (0=least significant, rightmost digit)
*/
#define BX_REG_DISP_DIGIT0                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x08))
#define BX_REG_DISP_DIGIT1                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x0a))
#define BX_REG_DISP_DIGIT2                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x0c))
#define BX_REG_DISP_DIGIT3                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x0e))

/* The following four addressses are used to set properties for 
   each Digit, e.g. intensity,blanking by OR-ing the following values.
   Default: Set all zero, i.e. no cursor,allow blanking,show characters,
            100% intensity, extended functions enabled 
*/
#define BX_REG_DISP_CTRL0                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x00))
#define BX_REG_DISP_CTRL1                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x02))
#define BX_REG_DISP_CTRL2                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x04))
#define BX_REG_DISP_CTRL3                        ((UWORDADDR)(BX_DISPLAY_OFFSET + 0x06))

/* Bit definitions for CTRL-registers */
#define BX_REG_DISP_CTRL_CURSOR       0x01   /* Bit 0: display cursor */
#define BX_REG_DISP_CTRL_BLANKDISABLE 0x02   /* Bit 1: prevents digit from beeing blanked */
#define BX_REG_DISP_CTRL_BLANK        0x04   /* Bit 2: blank digit */

/* Bit 3,4,5: Intensity */
#define BX_REG_DISP_CTRL_ITS100       0x00   /* Intensity: 100% */
#define BX_REG_DISP_CTRL_ITS60        0x08   /* Intensity: 60%  */
#define BX_REG_DISP_CTRL_ITS40        0x10   /* Intensity: 40%  */
#define BX_REG_DISP_CTRL_ITS27        0x18   /* Intensity: 27%  */
#define BX_REG_DISP_CTRL_ITS17        0x20   /* Intensity: 17%  */
#define BX_REG_DISP_CTRL_ITS10        0x28   /* Intensity: 10%  */
#define BX_REG_DISP_CTRL_ITS7         0x30   /* Intensity: 7%   */
#define BX_REG_DISP_CTRL_ITS3         0x38   /* Intensity: 3%   */

/* Bit 6: Extended functions disable
          This disables the functions of bits 1-5 */
#define BX_REG_DISP_CTRL_EXTDIS       0x40

/*****************************************************************************
 * Flash memory
 *****************************************************************************/

/* valid entry */
#define BX_VALID_SIGNATURE 0x123455aa

/* Powerup loader code */
#define BX_LOADER_IMAGE                       0x100000

/* Status of relays */
#define BX_RELAY_STATUS                       0x3e0000

/* Expansion ROM image */
#define BX_EXPROM_IMAGE                       0x0c0000
#define BX_EXPROM_IMAGE_SIZE                  0x010000 /* 64 kByte */

/* Firmware */
#define BX_FIRMWARE_IMAGE                     0x060000
#define BX_DEFAULT_PRODUCT_STRING             (BX_FIRMWARE_IMAGE+0x800)
#define BX_REG_BIOS_VERSION_NUMBER            (BX_FIRMWARE_IMAGE+0x81c)  /* Bios.Bios */
#define BX_REG_CORE_VERSION_NUMBER_FROM_BIOS  (BX_FIRMWARE_IMAGE+0x820)  /* Bios.Core */

/* Core */ 
#define BX_CORE_IMAGE                         0x000000
#define BX_REG_CORE_VERSION_NUMBER            (BX_CORE_IMAGE+0x00081C)  /* Core.Core */

/* Coco CPLD (64KB) */
#define BX_COCO_OFFSET                   0x00E00000
#define BX_COCO_OFFSET_END               0x00E0fffe
#define BX_REG_COCO_STATUS              ((UWORDADDR) (BX_COCO_OFFSET+0x0))
#define BX_REG_COCO_PAGEPTR             ((UWORDADDR) (BX_COCO_OFFSET+0x2))
#define BX_REG_COCO_IMG_SELECT          ((UWORDADDR) (BX_COCO_OFFSET+0x4))
#define BX_REG_COCO_IMG_RELOAD          ((UWORDADDR) (BX_COCO_OFFSET+0x6))
#define BX_REG_COCO_DBI_RW              ((UWORDADDR) (BX_COCO_OFFSET+0x8))
#define BX_REG_COCO_VERSION             ((UWORDADDR) (BX_COCO_OFFSET+0xa))


/* The following macro computes the DBI address from the HW-flashaddress and the Flash Chip (0 or 1).
   Caution: flashaddr is a word address !!
  
   Explanation:
   Both flash chips have 22 address lines (A[21-0]) and an enable (CE_N) pin.
   Window page pointer (BX_REG_COCO_PAGEPTR) has 4 bits (PAGE[3-0]).
   DBI bus has address lines (DBI[19-0]).

   The upper four flashaddresses A[21-18] are determined by the window page pointer;
   the lower flashaddresses A[17-0] are connected to the DBI bus:
   A[21-18]=PAGE[3-0]   // must be separately set by BestXDirectRegWrite(BX_REG_COCO_PAGEPTR,A[21-18])
   A[17-0]=DBI[19-2]    // handled by this macro

   The chip enable CE_N pin is connected to DBI[1] (negated for chip 1):
   CE_N=DBI[1]        for chip0 resp.
   CE_N=DBI[1]_N      for chip1 
   So DBI[1] selects the chip to be addressed:
   DBI addresses with bit 1 set, go to chip 1, whereas
   DBI addresses with bit 1 not set, enable chip 0.

   BX_FAUST_IMAGEPAGE_START is the 1MB DBI address offset into the HW flash window.
*/

#define FLASH2DBI(flashaddr,chip) (BX_FAUST_IMAGEPAGE_START | (((ULONG)flashaddr&0x3ffff)<<2) | (chip?0x2:0))

/* Xilinx */
#define BX_XILINX_IMAGE                       0x10000
#define BX_XILINX_DATECODE                    (BX_XILINX_IMAGE+0xbd62) /* last S2 record at 0x1bd62*/

/* Fred */
#define BX_FRED_IMAGE                         0x10000
#define BX_FRED_DATECODE                      (BX_FRED_IMAGE+0x1fbdc) /* last S2 record at 0x2fbdc */

/* Altera */
#define BX_DEEPTRACEALTERA_IMAGE              0x20000
#define BX_DEEPTRACEALTERA_DATECODE_ADDR      (BX_DEEPTRACEALTERA_IMAGE+0x3c0f2)

/* Misc (version strings) */
#define BX_VERSION_SIGNATURE            0x000e0000
#define BX_OVERLOADED_PRODUCT_STRING    (BX_VERSION_SIGNATURE+0xc)
#define BX_PRODUCT_STRING_LENGTH        0x14UL

#define BX_SERIAL_NUMBER (BX_VERSION_SIGNATURE+0x20)
#define BX_PRODUCTION_DATE (BX_VERSION_SIGNATURE+0x34)
#define BX_BOARD_ID (BX_VERSION_SIGNATURE+0x48)

#define BX_SERIAL_NUMBER_LENGTH 0x14UL
#define BX_PRODUCTION_DATE_LENGTH 0x14UL
#define BX_BOARD_ID_LENGTH  0x14UL

/*****************************************************************************
 * Xilinx
 *****************************************************************************/

#define BX_REG_XILINX_PCI                      (UWORDADDR)0x00500002
#  define BX_MASK_XILINX_PCI_PME                0x1
#  define BX_MASK_XILINX_PCI_A14                0x2
#  define BX_MASK_XILINX_PCI_PIGGYBACK          0x4
#  define BX_MASK_XILINX_PCI_DBI_ARB_EN         0x8    


/* Hardware Diagonstics: Temperature, Fan speed, Voltages */
#define BX_REG_XILINX_DIAG_BASE   0x530000      
#define BX_REG_DIAG_CONTROL   ((UWORDADDR) (BX_REG_XILINX_DIAG_BASE + 0x0))  
#define BX_REG_DIAG_ADDRESS   ((UWORDADDR) (BX_REG_XILINX_DIAG_BASE + 0x2))
#define BX_REG_DIAG_COMMAND   ((UWORDADDR) (BX_REG_XILINX_DIAG_BASE + 0x4)) 
#define BX_REG_DIAG_DATA      ((UWORDADDR) (BX_REG_XILINX_DIAG_BASE + 0x6))


/*****************************************************************************
 *  PiggyBack Boards (i.e. either deeptrace or future+ board)
 *****************************************************************************/

#define BX_PIGGY_BASE            0x00490000

/* The identity register exists on both boards and allows us to
   determine, wether an option100 (deep trace) or option 120 (future+)
   board is onboard. Before reading this register, you should check 
   the existence of a piggyback board by reading the Xilinx's PCI register
   (if you do not, you'll die with a bus error).
*/
#define BX_PIGGY_ID_MASK                0x7     
#define BX_REG_PIGGY_ID                        ((UWORDADDR) BX_PIGGY_BASE + 0x0000)      
#define BX_PIGGY_ID_DT                  0x1     /* deep trace resp. option 100 */
#define BX_PIGGY_ID_FP                  0x2     /* future+ resp. option 120    */

/*****************************************************************************
 *  Deep Trace board (option 100)
 *****************************************************************************/

#define BX_DEEPTRACE_BASE_M               BX_PIGGY_BASE
#define BX_DEEPTRACE_BASE_F /* Faust */  (BX_MEPHISTO_OFFSET + 0x3e00)           

/* Mephisto only */
#define BX_REG_DT_ID_M                    ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0000))      
#define BX_REG_DT_CONTROL_M               ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0004))
#define BX_REG_DT_STATUS_M                ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0006))
#define BX_REG_DT_DATAREAD_HI_M           ((ULONGADDR)(BX_DEEPTRACE_BASE_M + 0x0008))
#define BX_REG_DT_DATAREAD_LO_M           ((ULONGADDR)(BX_DEEPTRACE_BASE_M + 0x000A))
#define BX_REG_DT_ADDR_HI_M               ((ULONGADDR)(BX_DEEPTRACE_BASE_M + 0x000C))
#define BX_REG_DT_ADDR_LO_M               ((ULONGADDR)(BX_DEEPTRACE_BASE_M + 0x000E))
#define BX_REG_DT_LATCH_READ_START_M      ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0010))
#define BX_REG_DT_LATCH_READ_STOP_M       ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0012))
#define BX_REG_DT_VERSION_M               ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0014))
#define BX_REG_DT_LED_M                   ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0016))
#define BX_REG_DT_LAST_W_ADDR_HI_M        ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0018))
#define BX_REG_DT_LAST_W_ADDR_LO_M        ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x001A))
#define BX_REG_DT_CONFIG_M                ((UWORDADDR)(BX_DEEPTRACE_BASE_M + 0x0020))

/* Faust only */
#define BX_REG_DT_CONTROL_F               ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x0004))
#define BX_REG_DT_STATUS_F                ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x0006))
#define BX_REG_DT_DATAREAD_F              ((ULONGADDR)(BX_DEEPTRACE_BASE_F + 0x0008))
#define BX_REG_DT_ADDR_HI_F               ((ULONGADDR)(BX_DEEPTRACE_BASE_F + 0x000C))
#define BX_REG_DT_ADDR_LO_F               ((ULONGADDR)(BX_DEEPTRACE_BASE_F + 0x000E))
#define BX_REG_DT_LATCH_READ_START_F      ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x0010))
#define BX_REG_DT_LATCH_READ_STOP_F       ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x0012))
#define BX_REG_DT_LAST_W_ADDR_HI_F        ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x0018))
#define BX_REG_DT_LAST_W_ADDR_LO_F        ((UWORDADDR)(BX_DEEPTRACE_BASE_F + 0x001A))


/*****************************************************************************
 *  Future+ board (option 120)
 *****************************************************************************/

#define BX_FUTUREPLUS_BASE              BX_PIGGY_BASE

#define BX_REG_FP_ID                    ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0000))      
#define BX_REG_FP_RST                   ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0002))
#define BX_REG_FP_DIP1                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0010))
#define BX_REG_FP_DIP2                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0012))
#define BX_REG_FP_DIP3                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0014))
#define BX_REG_FP_DIP4                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0016))
#define BX_REG_FP_LED1                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0020))
#define BX_REG_FP_LED2                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0022))
#define BX_REG_FP_LED3                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0024))
#define BX_REG_FP_LED4                  ((UWORDADDR)(BX_FUTUREPLUS_BASE + 0x0026))


/*****************************************************************************
 * Performance Sequencers
 *****************************************************************************/

/* Address difference between the performance blocks/sequencers */
#define BX_PERFSEQ_ADDR_OFFS ((ULONG)BX_REG_BLK1_RAM_CNTR-(ULONG)BX_REG_BLK0_RAM_CNTR) /* 0x80 */

/* Address difference between the split conditions decoders */
#define BX_SPLITCOND_ADDR_OFFS ((ULONG)BX_REG_TSPLIT1_ADDRMASK_LO_REG-(ULONG)BX_REG_TSPLIT0_ADDRMASK_LO_REG) /* 0x20 */

/*****************************************************************************
 * Resource Lock register  
 *****************************************************************************/

/* These are definitions for the Resource-Lock-Masks 
 * Abbreviations: E=Exerciser, A=Analyzer, O=Observer, P=Performance
 * Bit:          Resource:  Locked by:
 * {31,30,29,28} {O,P,A,E}  USB  
 * {27,26,25,24} {O,P,A,E}  Parallel
 * {23,22,21,20} {O,P,A,E}  PCI
 * {19,18,17,16} {O,P,A,E}  RS232
 *
 * bits 0-15 are untouched by the resource locking functions !
*/

#define BX_PORT_IS_RS232 (16)    /* bits 16-19   *//* used to shift 16 bits*/
#define BX_PORT_IS_PCI   (20)    /* bits 20-23   *//* used to shift 20  bits*/
#define BX_PORT_IS_FHIF  (24)    /* bits 24-27   *//* used to shift 24  bits*/
#define BX_PORT_IS_USB   (28 )   /* bits 28-31   *//* used to shift 28 bits*/
#define BX_PORT_IS_OFFLINE (255) /* in this case: no locking ! */
#define BX_PORT_IS_PRODUCTION (250) /* sorry, production special hack ... */

#define BX_EXERCISER_LOCK_MASK (1)
#define BX_ANALYZER_LOCK_MASK  (2)
#define BX_PERFORMANCE_LOCK_MASK (4)
#define BX_OBSERVER_LOCK_MASK (8)

/* Bits 0-15 are used by the Powerup loader */
#define BX_PU_COUNTERMASK 0xff /* lowest byte for debug counter */

/*****************************************************************************
 * MEPHISTO Versions
 *****************************************************************************/

#define BX_MEPHISTO_MMC1_MMC2         (0x0300)
#define BX_MEPHISTO_CUT2              (0x0310)

#endif /* XADDRMAP_H_INCLUDED */
